package h.com.newserialapp.activity.MIAFREDESFireActivity;

import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import h.com.newserialapp.R;
import h.com.newserialapp.SerialAPP;
import h.com.newserialapp.activity.MIAFREDESFireActivity.ApplicationLevel.BackupFile;
import h.com.newserialapp.activity.MIAFREDESFireActivity.ApplicationLevel.FileInformation;
import h.com.newserialapp.activity.MIAFREDESFireActivity.ApplicationLevel.RecordFile;
import h.com.newserialapp.activity.MIAFREDESFireActivity.ApplicationLevel.StandardDataFile;
import h.com.newserialapp.activity.MIAFREDESFireActivity.ApplicationLevel.ValueFile;
import h.com.newserialapp.activity.MainActivity;
import h.com.newserialapp.views.RechargeDialog;
import h.com.serialportapi.comn.Reader;
import h.com.serialportapi.comn.SerialPortManager;

/**
 * Created by hxd on 2018/12/9.
 */

public class ApplicationLevelActivity extends AppCompatActivity implements View.OnClickListener {
    private Button btFileInformation, btStandardDataFile, btBackupFile, btValueFile, btRecordFile, btBackToPrevious, btBackToMainMenu;
    private RechargeDialog dialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_applicationlevel);
        bindView();
    }

    void bindView() {
        Typeface typeface = Typeface.createFromAsset(this.getAssets(), "fonts/Eurostile LT Demi.ttf");
        btFileInformation = findViewById(R.id.bt_file_information);
        btStandardDataFile = findViewById(R.id.bt_standard_data_file);
        btBackupFile = findViewById(R.id.bt_backup_file);
        btValueFile = findViewById(R.id.bt_value_file);
        btRecordFile = findViewById(R.id.bt_record_file);
        btBackToPrevious = findViewById(R.id.bt_back_to_previous);
        btBackToMainMenu = findViewById(R.id.bt_back_to_main_menu);
        btFileInformation.setOnClickListener(this);
        btStandardDataFile.setOnClickListener(this);
        btBackupFile.setOnClickListener(this);
        btValueFile.setOnClickListener(this);
        btRecordFile.setOnClickListener(this);
        btBackToPrevious.setOnClickListener(this);
        btBackToMainMenu.setOnClickListener(this);
        btFileInformation.setTypeface(typeface);
        btStandardDataFile.setTypeface(typeface);
        btBackupFile.setTypeface(typeface);
        btValueFile.setTypeface(typeface);
        btRecordFile.setTypeface(typeface);
        btBackToPrevious.setTypeface(typeface);
        btBackToMainMenu.setTypeface(typeface);
        dialog = new RechargeDialog(this, R.style.recharge_dialog);
        // btValueFile.setText(Html.fromHtml("蓝颜色:<font color='#0000FF'>蓝颜色</font>"));
       /* SpannableString spannableString01 = new SpannableString("Standard Data File (note:need file IDs)");
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(Color.RED);
        spannableString01.setSpan(foregroundColorSpan, 19, spannableString01.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan(18);
        spannableString01.setSpan(absoluteSizeSpan, 19, spannableString01.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        btStandardDataFile.setText(spannableString01);

        SpannableString spannableString02 = new SpannableString("Backup File (note:need file IDs)");
        ForegroundColorSpan foregroundColorSpan02 = new ForegroundColorSpan(Color.RED);
        spannableString02.setSpan(foregroundColorSpan02, 12, spannableString02.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        AbsoluteSizeSpan absoluteSizeSpan02 = new AbsoluteSizeSpan(18);
        spannableString02.setSpan(absoluteSizeSpan02, 12, spannableString02.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        btBackupFile.setText(spannableString02);

        SpannableString spannableString03 = new SpannableString("Value File (note:need File IDs)");
        ForegroundColorSpan foregroundColorSpan03 = new ForegroundColorSpan(Color.RED);
        spannableString03.setSpan(foregroundColorSpan03, 11, spannableString03.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        AbsoluteSizeSpan absoluteSizeSpan03 = new AbsoluteSizeSpan(18);
        spannableString03.setSpan(absoluteSizeSpan03, 11, spannableString03.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        btValueFile.setText(spannableString03);

        SpannableString spannableString04 = new SpannableString("Record File (note:need File IDs)");
        ForegroundColorSpan foregroundColorSpan04 = new ForegroundColorSpan(Color.RED);
        spannableString04.setSpan(foregroundColorSpan04, 12, spannableString04.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        AbsoluteSizeSpan absoluteSizeSpan04 = new AbsoluteSizeSpan(18);
        spannableString04.setSpan(absoluteSizeSpan04, 12, spannableString04.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        btRecordFile.setText(spannableString04);*/
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_file_information:
                startActivity(new Intent(this, FileInformation.class));
                break;
            case R.id.bt_standard_data_file:
               // if (SerialAPP.getFileIds() != null) {
                    startActivity(new Intent(this, StandardDataFile.class));
              //  } else {
              //      dialog.show();
              //  }
                break;
            case R.id.bt_backup_file:
                //if (SerialAPP.getFileIds() != null) {
                    startActivity(new Intent(this, BackupFile.class));
              //  } else {
               //     dialog.show();
               // }
                break;
            case R.id.bt_value_file:
               // if (SerialAPP.getFileIds() != null) {
                    startActivity(new Intent(this, ValueFile.class));
                //} else {
                //    dialog.show();
               // }
                break;
            case R.id.bt_record_file:
               // if (SerialAPP.getFileIds() != null) {
                    startActivity(new Intent(this, RecordFile.class));
               // } else {
              //      dialog.show();
               // }
                break;
            case R.id.bt_back_to_previous:
                finish();
                break;
            case R.id.bt_back_to_main_menu:
                startActivity(new Intent(this, MainActivity.class));
                finish();
                break;

        }
    }
}
